
//+++++++++++++++++++++++++++++++++++++++
//
//Propagation of Gaussian Beam
//
//+++++++++++++++++++++++++++++++++++++++
proc SrwExamGsnBm()

srwUtiShowHelpTopic("Gaussian Beam Definition and Propagation     ")

// Initialization
SrwInit(2)

//Suppress printing of aux. SRW messages to the History window
SrwUtiTriggerPrint(2)
//Start timer
Variable t0=stopmstimer(0)
t0=startmstimer

//Create Radiation Sampling structure specifying distance from the source, at which the initial wavefront 
//will be computed, transverse size of the wavefront and photon energy.
Variable Robs=20 //[m]
Variable dx=0.3, dz=0.3 //[mm]
Variable Eph=12.416 //[keV]
SrwSmpCreate("ObsXZ",Robs);SrwSmpScanXZE("ObsXZ_obs",0,dx,1,0,dz,1,Eph,Eph,1)

//Create Electron Beam
SrwElecFilament("Elec",25,6e-05,0,0,0,0,0);SrwElecThick("Elec_ebm",0.001,0.02,0.02,15,15,0,0,0,0)
//Create Gaussian Beam
SrwGsnBeam("Gsn","Elec_ebm",10,10,0,0,1,1)

//Compute analytically initial wavefront and display it
SrwWfrGsnBeamCreate("GsnObsXZ","Gsn_gsb","ObsXZ_obs",2,1)
SrwWfr2Int("GsnObsXZ_rad","I",7,1,4,1,12.416,0,0,2)
Textbox/N=text0/F=0 " Spectral flux / surface \r at " + num2str(Robs) + " m from source "
SrwWfr2Int("GsnObsXZ_rad","I",7,1,2,1,12.416,0,0,2)
Textbox/N=text0/F=0 " Spectral flux / surface \r at " + num2str(Robs) + " m from source \r Horizontal profile \r Linear scale "
Display GsnObsXZI_x
ModifyGraph log(left)=1
Textbox/N=text0/F=0 " Spectral flux / surface \r at " + num2str(Robs) + " m from source \r Horizontal profile \r Logarithmic scale "

//Create Drift Space
Variable L=300 //[m]
SrwOptDrift("Drift",L)

//Propagate (numerically) the wavefront and display it
SrwWfrPropagate("GsnObsXZ_rad","Drift_bli",1,2,"GsnObsXZd")
SrwWfr2Int("GsnObsXZd_rad","I",7,1,4,1,12.416,0,0,2)
Textbox/N=text0/F=0 " Spectral flux / surface \r at " + num2str(Robs+L) + " m from source "
SrwWfr2Int("GsnObsXZd_rad","I",7,1,2,1,12.416,0,0,2)

//Compute analytically another wavefront at the distance Robs + L from the source and compare it with the one propagated numerically
SrwSmpCreate("ObsXZ1",Robs+L);SrwSmpScanXZE("ObsXZ1_obs",0,3,1,0,3,1,Eph,Eph,1)
SrwWfrGsnBeamCreate("GsnObsXZ1","Gsn_gsb","ObsXZ1_obs",2,1)
SrwWfr2Int("GsnObsXZ1_rad","I",7,1,2,1,12.416,0,0,1)
AppendToGraph GsnObsXZ1I_x
ModifyGraph rgb(GsnObsXZ1I_x)=(0,0,65280)
Textbox/N=text0/F=0 " Spectral flux / surface \r at " + num2str(Robs+L) + " m from source \r Horizontal profile \r red- numer. propag. \r blue- analyt. propag. \r Linear scale "

Display GsnObsXZdI_x,GsnObsXZ1I_x
ModifyGraph rgb(GsnObsXZ1I_x)=(0,0,65280)
ModifyGraph log(left)=1
Textbox/N=text0/F=0 " Spectral flux / surface \r at " + num2str(Robs+L) + " m from source \r Horizontal profile \r red- numer. propag. \r blue- analyt. propag. \r Logarithmic scale "

TileWindows/O=1/C
srwUtiShowHelpTopic("Gaussian Beam Definition and Propagation     ")

print "CPU Time : ",srround(stopmstimer(t0)/1e6,1)," seconds"
SrwUtiTriggerPrint(1)

print " "
print "The macro generating this computation can be found in the file \"SRW Example GsnBm.ipf\""
print "that can be accessed through the menu \"Windows->Procedure Windows\" (assuming IGOR Pro version 6 or higher)"

end
